#ifndef _SERIAL_COMM
#define _SERIAL_COMM


#include "derivative.h" /* include peripheral declarations */
#include "PublicTypes.h"


#define REQ		0x52
#define CFM		0x43
#define IND		0x69


typedef enum
{
	GLU_START_MEASUREMENT,
	GLU_ABORT_MEASUREMENT,
	GLU_START_CALIBRATION,
	GLU_BLOOD_DETECTED,
	GLU_MEASUREMENT_COMPLETE_OK,
	GLU_CALIBRATION_COMPLETE_OK,
	
	BPM_START_MEASUREMENT,
	BPM_ABORT_MEASUREMENT,
	BPM_MEASUREMENT_COMPLETE_OK,
	BPM_MEASUREMENT_ERROR,
	
	//leak test	
	BPM_START_LEAK_TEST,
	BPM_ABORT_LEAK_TEST,
	BPM_LEAK_TEST_COMPLETE,	
	
	ECG_HEART_RATE_START_MEASUREMENT,
	ECG_HEART_RATE_ABORT_MEASUREMENT,
	ECG_HEART_RATE_MEASUREMENT_COMPLETE_OK,
	ECG_HEART_RATE_MEASUREMENT_ERROR,
	ECG_HEART_BEAT_OCCURRED,
	
	ECG_DIAGNOSTIC_MODE_START_MEASUREMENT,
	ECG_DIAGNOSTIC_MODE_STOP_MEASUREMENT,
	ECG_DIAGNOSTIC_MODE_NEW_DATA_READY,	
	
	TMP_READ_TEMPERATURE,
	HGT_READ_HEIGHT,
	WGT_READ_WEIGHT,
	
	SPR_START_MEASUREMENT,
	SPR_ABORT_MEASUREMENT,
	SPR_MEASUREMENT_COMPLETE_OK,
	SPR_MEASUREMENT_ERROR,

	SPR_DIAGNOSTIC_MODE_START_MEASUREMENT,
	SPR_DIAGNOSTIC_MODE_STOP_MEASUREMENT,
	SPR_DIAGNOSTIC_MODE_NEW_DATA_READY,
	SPR_DIAGNOSTIC_MODE_MEASUREMENT_COMPLETE_OK,
	SPR_DIAGNOSTIC_MODE_MEASUREMENT_ERROR,

	
	SPO2_START_MEASUREMENT,
	SPO2_ABORT_MEASUREMENT,
	SPO2_MEASUREMENT_COMPLETE_OK,
	SPO2_MEASUREMENT_ERROR,
	
	SPO2_DIAGNOSTIC_MODE_START_MEASUREMENT,
	SPO2_DIAGNOSTIC_MODE_STOP_MEASUREMENT,
	SPO2_DIAGNOSTIC_MODE_NEW_DATA_READY,
		
	BPM_SEND_PRESSURE_VALUE_TO_PC,	//40
	
	SYS_CHECK_DEVICE_CONNECTION,	//41
	SYS_RESTART_SYSTEM,				//42
	
	GLU_DEBUG_MODE_NEW_DATA_READY = 0xFD,
	SPO2_DEBUG_MODE_NEW_DATA_READY = 0xFE,
	BPM_DEBUG_MODE_NEW_DATA_READY = 0xFF,

} CommandsOpCode_e;


#define FIRST_COMMAND		0
#define LAST_COMMAND		0xFF


typedef enum
{
	ERROR_OK,
	ERROR_BUSY,
	ERROR_INVALID_OPCODE
} ErrorCodes_e;



#define PACKET_TYPE			0
#define COMMAND_OPCODE		1
#define DATA_LENGTH			2
#define DATA_PACKET			3



#endif //_SERIAL_COMM